#pragma once

enum {

	VIDEO_NTSC	= 0x00000001,

	VIDEO_PAL	= 0x00000010,
};

// ENCODER VIDEO FORMAT (RECORD PROPERTY)
//
enum {

	VIDEO_FORMAT_H264	= 0,

	VIDEO_FORMAT_H265	= 1,
};

// ENCODER AUDIO FORMAT (RECORD PROPERTY)
//
enum {

	AUDIO_FORMAT_PCM						= 0,

	AUDIO_FORMAT_AAC						= 1,	

	AUDIO_FORMAT_AAC_ADTS			= 2,

	AUDIO_FORMAT_MP2						= 3,

	AUDIO_FORMAT_MP3						= 4,

	AUDIO_FORMAT_OPUS					= 5,
};

// FILE FORMAT (RECORD PROPERTY)
//
enum {

	FILE_FORMAT_MP4						= 0,

	FILE_FORMAT_TS							= 1,

	FILE_FORMAT_ASF						= 2,

	FILE_FORMAT_WMV					= 3,

	FILE_FORMAT_FLV						= 4,
};

// RECORD MODE (RECORD PROPERTY)
//
enum {

	RECORD_MODE_VBR					= 0,

	RECORD_MODE_CBR					= 1,

	RECORD_MODE_ABR					= 2,	
};


class CFileRenderer
{
public:

	CFileRenderer();

	virtual ~CFileRenderer();

	BOOL IsValid();

	BOOL StartRecording();

	BOOL StopRecording();		

public:
	
	BOOL								m_bIsValid;

	HWND								m_hWnd;

	CString								m_strChipName;

	BOOL								m_bIsRecording;

	BOOL								m_bIsSchedule;

	ULONG							m_nNO;

	ULONG							m_nCH;

	ULONG							m_nVideoStandard;

	ULONG							m_nVideoEncoderType;

	ULONG							m_nAudioEncoderType;

	ULONG							m_nFileType;

	// MAIN STREAM
	//
	ULONG							m_nMainFrameWidth;

	ULONG							m_nMainFrameHeight;

	ULONG							m_nMainDeinterlace;

	DOUBLE							m_nMainFrameRate;

	ULONG							m_nMainRecordMode;

	ULONG							m_nMainBitRate;

	ULONG							m_nMainQuality;

	ULONG							m_nMainGOP;

	ULONG							m_nMainBFrame;

	ULONG							m_nMainQualityMatrix[ 21 ];

	ULONG							m_nMainBitRateMatrix[ 14 ];

	// SUB STREAM
	//
	ULONG							m_nSubFrameWidth;

	ULONG							m_nSubFrameHeight;

	ULONG							m_nSubDeinterlace;

	DOUBLE							m_nSubFrameRate;

	ULONG							m_nSubRecordMode;

	ULONG							m_nSubBitRate;

	ULONG							m_nSubQuality;

	ULONG							m_nSubGOP;

	ULONG							m_nSubBFrame;

	ULONG							m_nSubQualityMatrix[ 21 ];

	ULONG							m_nSubBitRateMatrix[ 14 ];

	// MIAN STREAM FILE PROPERTY 
	// 
	DEVICE_HANDLE			m_hMainFileRendererDev;									// MIAN FILE RENDERER DEVICE

	ULONG							m_nMainFileRendererRecordState;						// MIAN FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	CRITICAL_SECTION		m_hMainFileRendererChangeCriticalSection;		// MIAN FILE RENDERER FILE.CHANGING.EVENT CRITICAL SECTION

	// SUB STREAM FILE PROPERTY 
	// 
	DEVICE_HANDLE			m_hSubFileRendererDev;									// SUB FILE RENDERER DEVICE

	ULONG							m_nSubFileRendererRecordState;						// SUB FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	CRITICAL_SECTION		m_hSubFileRendererChangeCriticalSection;		// SUB FILE RENDERER FILE.CHANGING.EVENT CRITICAL SECTION

	// DEVICE PROPERTY 
	// 
	ULONG							m_nVideoColorSapce;									// LIVE DATA COLORSPACE

	ULONG							m_nVideoBitCount;										// LIVE DATA BIT COUNT

	DEVICE_HANDLE			m_hVideoDev;											// VIDEO STREAM CAPTURE DEVICE

	DEVICE_HANDLE			m_hVideoSwEncoderDev;							// SOFTWARE (H.264/H.265) ENCODER DEVICE

	DEVICE_HANDLE			m_hVideoMainEncoderDev;						// H.264 MAIN.STREAM CAPTURE DEVICE

	DEVICE_HANDLE			m_hVideoSubEncoderDev;							// H.264 SUB.STREAM CAPTURE DEVICE

	DEVICE_HANDLE			m_hAudioDev;											// AUDIO STREAM CAPTURE DEVICE 

	DEVICE_HANDLE			m_hAudioSwEncoderDev;						    // SOFTWARE AUDIO ENCODER STREAM CAPTURE DEVICE 

private:	

	CString GetWorkingPath();

	void GetRecordingFilePathName( BOOL bIsSubStream , CString & strFile );
};

